set echo on
set lines 300
set pages 1000
prompt Create Index
pause
drop index DEMO.ORDERS_STATUS;

create index DEMO.ORDERS_CUST_STATUS
on DEMO.ORDERS(ORDER_STATUS,CUSTOMER_ID) 
COMPRESS 1;


prompt Execute Statement with Index Hint
pause
set termout off 
variable v1 number;
exec :v1 := 1001;
select /*+ GATHER_PLAN_STATISTICS INDEX(O ORDERS_STATUS) */ * from DEMO.CUSTOMERS C,
              DEMO.ORDERS O
WHERE O.CUSTOMER_ID = C.CUSTOMER_ID -- join predicate
      AND C.customer_id = :v1 -- filter predicate 
      and O.order_status = 'PENDING' --filter predicate
order by order_date -- sorting
;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));
