set echo on

prompt Flush Shared Pool
pause
alter system flush shared_pool;

prompt Gather Histogram on ORDERS.CUSTOMER_ID
pause
exec dbms_stats.gather_table_stats(ownname=>'DEMO',tabname=>'ORDERS',method_opt=>'FOR COLUMNS CUSTOMER_ID SIZE 254');

prompt Execute Query for Main Customer - will be full table scan due to histogram (CBO knows this is main customer)
pause
variable v1 number;
exec :v1 := 1001;
set termout off 
SELECT /*+ GATHER_PLAN_STATISTICS */ * from DEMO.ORDERS O WHERE CUSTOMER_ID = :v1;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));

prompt Bind Sensitive / Bind Aware?
pause
col is_bind_sensitive format a18
col is_bind_aware format a18
col is_sharable format a18
col child_number format number 99

select sql_id, child_number, is_bind_sensitive, is_bind_aware, is_shareable from v$sql where sql_id = '9wp1bzn127thb';



prompt Execute Query for Small Customer - no new parsing, reusing parsed plan from main customer - again full table scan!
pause
variable v1 number;
exec :v1 := 1003;
set termout off
SELECT /*+ GATHER_PLAN_STATISTICS */ * from DEMO.ORDERS O WHERE CUSTOMER_ID = :v1;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));

prompt Bind Sensitive / Bind Aware?
pause
col is_bind_sensitive format a18
col is_bind_aware format a18
col is_sharable format a18
col child_number format number 99

select sql_id, child_number, is_bind_sensitive, is_bind_aware, is_shareable from v$sql where sql_id = '9wp1bzn127thb';


prompt Now Adaptive Cursor Sharing Kicks in....
prompt CBO realized that Full Table Scan for small Customer was not optimal after all
pause

prompt Execute Query for Main Customer ... still full scan
pause
variable v1 number;
exec :v1 := 1001;
set termout off
SELECT /*+ GATHER_PLAN_STATISTICS */ * from DEMO.ORDERS O WHERE CUSTOMER_ID = :v1;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));

prompt Bind Sensitive / Bind Aware?
pause
col is_bind_sensitive format a18
col is_bind_aware format a18
col is_sharable format a18
col child_number format number 99

select sql_id, child_number, is_bind_sensitive, is_bind_aware, is_shareable from v$sql where sql_id = '9wp1bzn127thb';



prompt Execute Query for Small Customer ... now index range scan - optimal for small customer
pause
variable v1 number;
exec :v1 := 1003;
set termout off
SELECT /*+ GATHER_PLAN_STATISTICS */ * from DEMO.ORDERS O WHERE CUSTOMER_ID = :v1;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));

prompt Bind Sensitive / Bind Aware?
pause
col is_bind_sensitive format a18
col is_bind_aware format a18
col is_sharable format a18
col child_number format number 99

select sql_id, child_number, is_bind_sensitive, is_bind_aware, is_shareable from v$sql where sql_id = '9wp1bzn127thb';


prompt Flush Shared Pool - CBO looses Adaptive Cursor Sharing Info from Shared Pool
pause
alter system flush shared_pool;

prompt Execute Query for Main Customer - Full Table Scan
pause
variable v1 number;
exec :v1 := 1001;
set termout off
SELECT /*+ GATHER_PLAN_STATISTICS */ * from DEMO.ORDERS O WHERE CUSTOMER_ID = :v1;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));

prompt Bind Sensitive / Bind Aware?
pause
col is_bind_sensitive format a18
col is_bind_aware format a18
col is_sharable format a18
col child_number format number 99

select sql_id, child_number, is_bind_sensitive, is_bind_aware, is_shareable from v$sql where sql_id = '9wp1bzn127thb';



prompt Execute Query for Small Customer - Again Full Table Scan
pause
variable v1 number;
exec :v1 := 1003;
set termout off
SELECT /*+ GATHER_PLAN_STATISTICS */ * from DEMO.ORDERS O WHERE CUSTOMER_ID = :v1;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));

prompt Bind Sensitive / Bind Aware?
pause
col is_bind_sensitive format a18
col is_bind_aware format a18
col is_sharable format a18
col child_number format number 99

select sql_id, child_number, is_bind_sensitive, is_bind_aware, is_shareable from v$sql where sql_id = '9wp1bzn127thb';



prompt Removing Histogram
pause
exec dbms_stats.gather_table_stats(ownname=>'DEMO',tabname=>'ORDERS', method_opt=>'FOR ALL COLUMNS SIZE 1');
exit
