set echo on
set lines 300
set pages 1000

prompt Create new Table
pause
drop table demo.orders_sorted purge;
create table demo.orders_sorted as 
select * from demo.orders 
order by customer_id, order_status;

prompt Creating Index
pause
alter table demo.orders_sorted add constraint orders_sorted_pk primary key (order_id);
create index demo.orders_sort_customer_idx on demo.orders_sorted(customer_id);
alter table demo.orders_sorted add constraint ordsort_cust_fk foreign key (customer_id) references demo.customers(customer_id);

prompt Gather Stats
pause
exec dbms_stats.gather_table_stats(ownname=>'DEMO',tabname=>'ORDERS_SORTED', method_opt=>'FOR ALL COLUMNS SIZE 1');

prompt Executing SQL with reorg table:
pause
set termout off
variable v1 number;
exec :v1 := 1001;
SELECT /*+ GATHER_PLAN_STATISTICS */ * from DEMO.CUSTOMERS C,
              DEMO.ORDERS_SORTED O
WHERE O.CUSTOMER_ID = C.CUSTOMER_ID -- join predicate
      AND C.CUSTOMER_ID = :v1 -- filter predicate
      and O.ORDER_STATUS = 'PENDING' --filter predicate
ORDER BY ORDER_DATE -- sorting
;
set termout on
set lines 300
set pages 1000
select * from table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'));

exit
